<?php
$db_file = 'customers.db';

// データベースファイルが存在するか確認
$db_exists = file_exists($db_file);

try {
    // SQLiteデータベースに接続
    // ファイルが存在しない場合は自動的に作成される
    $db = new PDO('sqlite:' . $db_file);
    
    // エラーモードを例外に設定
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    // 連想配列形式でフェッチするよう設定
    $db->setAttribute(PDO::ATTR_DEFAULT_FETCH_MODE, PDO::FETCH_ASSOC);

    // データベースファイルが新規作成された場合のみ、テーブルを作成する
    if (!$db_exists) {
        $create_table_sql = "
            CREATE TABLE customers (
                id INTEGER PRIMARY KEY AUTOINCREMENT,
                name TEXT NOT NULL,
                name_kana TEXT,
                address TEXT,
                phone TEXT,
                email TEXT
            );
        ";
        // SQLを実行してテーブルを作成
        $db->exec($create_table_sql);
    }

} catch (PDOException $e) {
    echo "データベース処理でエラーが発生しました: " . $e->getMessage();
    exit;
}

// XSS対策の関数
function h($str) {
    return htmlspecialchars($str, ENT_QUOTES, 'UTF-8');
}
?>