<?php
require_once 'db.php';

// URLパラメータから顧客IDを取得
if (empty($_GET['id'])) {
    echo "IDが指定されていません。";
    exit;
}
$id = $_GET['id'];

// データベースから指定されたIDの顧客情報を取得
$stmt = $db->prepare("SELECT * FROM customers WHERE id = :id");
$stmt->bindValue(':id', $id, PDO::PARAM_INT);
$stmt->execute();
$customer = $stmt->fetch();

// 顧客情報が見つからない場合はエラーメッセージを表示して終了
if (!$customer) {
    echo "該当する顧客情報が見つかりません。";
    exit;
}
?>

<!DOCTYPE html>
<html lang="ja">
<head>
    <meta charset="UTF-8">
    <title>顧客情報編集</title>
</head>
<body>
    <h1>顧客情報編集</h1>
    
    <!-- 更新用フォーム -->
    <form action="update.php" method="post">
        <input type="hidden" name="id" value="<?= h($customer['id']) ?>">
        <p>
            <label for="name">顧客名 (必須):</label><br>
            <input type="text" id="name" name="name" value="<?= h($customer['name']) ?>" required>
        </p>
        <p>
            <label for="name_kana">顧客名フリガナ:</label><br>
            <input type="text" id="name_kana" name="name_kana" value="<?= h($customer['name_kana']) ?>">
        </p>
        <p>
            <label for="address">住所:</label><br>
            <textarea id="address" name="address" rows="5" cols="40"><?= h($customer['address']) ?></textarea>
        </p>
        <p>
            <label for="phone">電話番号:</label><br>
            <input type="text" id="phone" name="phone" value="<?= h($customer['phone']) ?>">
        </p>
        <p>
            <label for="email">メールアドレス:</label><br>
            <input type="email" id="email" name="email" value="<?= h($customer['email']) ?>">
        </p>
        <button type="submit">更新</button>
    </form>
    
    <hr>
    
    <!-- 削除用フォーム -->
    <form action="delete.php" method="post" onsubmit="return confirm('本当に削除しますか？');">
        <input type="hidden" name="id" value="<?= h($customer['id']) ?>">
        <button type="submit">この顧客情報を削除する</button>
    </form>
    
    <p><a href="index.php">一覧に戻る</a></p>
</body>
</html>