import openpyxl
import pyautogui
import time
import pyperclip  # クリップボード操作のために追加

# --- 設定項目 ---
# Excelファイル名とシート名
EXCEL_FILE_NAME = 'customer.xlsx'
SHEET_NAME = 'customer'

# --- 注意事項 ---
# このプログラムは、画面の解像度やアプリケーションのウィンドウサイズが常に同じであることを前提としています。
# 実行する前に、転記先のアプリケーションを操作しやすい状態（例：最大化など）で開いておいてください。
#
# プログラムを緊急停止したい場合は、マウスカーソルを画面の左上隅（座標 x=0, y=0）に素早く移動させてください。
# (pyautoguiのフェールセーフ機能)

def paste_text(text):
    """
    クリップボードを使ってテキストを貼り付ける関数
    日本語（全角文字）の入力に強い
    """
    pyperclip.copy(text)
    pyautogui.hotkey('ctrl', 'v')


def main():
    """
    Excelから顧客データを読み込み、指定された座標に転記・登録するメインの関数
    """
    try:
        workbook = openpyxl.load_workbook(EXCEL_FILE_NAME)
        sheet = workbook[SHEET_NAME]
    except FileNotFoundError:
        print(f"エラー: '{EXCEL_FILE_NAME}' が見つかりません。")
        return
    except KeyError:
        print(f"エラー: '{EXCEL_FILE_NAME}' 内に '{SHEET_NAME}' シートが見つかりません。")
        return

    print("データ転記プログラムを開始します。5秒後に処理を始めます...")
    print("【重要】5秒の間に、転記先のアプリケーションウィンドウをクリックしてアクティブにしてください。")
    print("緊急停止するには、マウスを画面の左上隅に移動してください。")
    time.sleep(5)

    # 2行目から最終行までループ処理
    for row in sheet.iter_rows(min_row=2):
        customer_name = row[0].value
        furigana = row[1].value
        phone_number = row[2].value
        email = row[3].value
        address = row[4].value

        if not customer_name:
            continue

        print(f"--- {customer_name}様のデータを転記します ---")

        try:
            # 1. 新規登録ボタンなどをクリック
            pyautogui.click(x=517, y=794)
            time.sleep(1.5)  # 画面遷移のため、少し長めに待つ

            # 2. 顧客名を入力 (コピー＆ペースト)
            pyautogui.click(x=840, y=422)
            time.sleep(0.5) # クリック後に少し待つ
            paste_text(str(customer_name))
            time.sleep(0.5)

            # 3. フリガナを入力 (コピー＆ペースト)
            pyautogui.click(x=840, y=467)
            time.sleep(0.5)
            paste_text(str(furigana))
            time.sleep(0.5)

            # 4. 電話番号を入力 (コピー＆ペースト)
            pyautogui.click(x=840, y=518)
            time.sleep(0.5)
            paste_text(str(phone_number))
            time.sleep(0.5)

            # 5. メールアドレスを入力 (コピー＆ペースト)
            pyautogui.click(x=840, y=566)
            time.sleep(0.5)
            paste_text(str(email))
            time.sleep(0.5)

            # 6. 住所を入力 (コピー＆ペースト)
            pyautogui.click(x=840, y=605)
            time.sleep(0.5)
            paste_text(str(address))
            time.sleep(0.5)

            # 7. 登録ボタンなどをクリック
            pyautogui.click(x=920, y=738)
            time.sleep(2)  # 登録処理のため、長めに待つ

            # 8. 次のレコード入力に進むためのクリック
            pyautogui.click(x=1039, y=628)
            time.sleep(1.5) # 次の処理に備える

            print(f"{customer_name}様のデータ転記完了。")

        except pyautogui.FailSafeException:
            print("緊急停止しました。")
            return

    print("すべてのデータの転記が終了しました。")

if __name__ == "__main__":
    main()