import tkinter as tk
import pyautogui

class MouseCoordinator:
    def __init__(self, root):
        self.root = root
        self.root.title("マウス座標")
        
        self.root.overrideredirect(True)
        
        # --- 変更点：ウィンドウ幅を少し広げました ---
        self.root.geometry("300x50+100+100")
        # --- 変更ここまで ---
        
        self.root.attributes("-topmost", True)
        self.root.resizable(False, False)
        
        self._offset_x = 0
        self._offset_y = 0

        self.root.bind("<ButtonPress-1>", self.click_win)
        self.root.bind("<B1-Motion>", self.drag_win)
        
        # --- 変更点：レイアウト調整とボタンの追加 ---
        # 座標を表示するラベル
        self.label = tk.Label(root, text="", font=("Helvetica", 16))
        # packのオプションで左寄せにし、左右に余白を追加
        self.label.pack(side=tk.LEFT, padx=10, pady=10)

        # 終了ボタン
        # commandに self.root.destroy を指定すると、クリック時にウィンドウを閉じる
        self.close_button = tk.Button(root, text="×", command=self.root.destroy, font=("Helvetica", 12, "bold"), fg="red", bg="lightgray", relief="flat")
        # packのオプションで右寄せにし、左右に余白を追加
        self.close_button.pack(side=tk.RIGHT, padx=(0, 10))
        # --- 変更ここまで ---

        self.update_coords()

    def update_coords(self):
        x, y = pyautogui.position()
        self.label.config(text=f"X: {x}, Y: {y}")
        self.root.after(10, self.update_coords)

    def drag_win(self, event):
        x = self.root.winfo_pointerx() - self._offset_x
        y = self.root.winfo_pointery() - self._offset_y
        self.root.geometry(f"+{x}+{y}")

    def click_win(self, event):
        self._offset_x = event.x
        self._offset_y = event.y

if __name__ == "__main__":
    root = tk.Tk()
    app = MouseCoordinator(root)
    root.mainloop()