<?php
require_once 'database.php';

$id = $_GET['id'] ?? null;

if (!$id || !filter_var($id, FILTER_VALIDATE_INT)) {
    die("無効なIDです。");
}

$pdo = get_db_connection();

try {
    $stmt = $pdo->prepare("SELECT * FROM customers WHERE id = :id");
    $stmt->bindValue(':id', $id, PDO::PARAM_INT);
    $stmt->execute();
    $customer = $stmt->fetch();
} catch (PDOException $e) {
    die("Error: " . $e->getMessage());
}

if (!$customer) {
    die("指定された顧客が見つかりません。");
}
?>
<!DOCTYPE html>
<html lang="ja">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>顧客情報更新・削除</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-9ndCyUaIbzAi2FUVXJi0CjmCapSmO7SnpJef0486qhLnuZ2cdeRhO02iuK6FUUVM" crossorigin="anonymous">
</head>
<body>
    <div class="container mt-4">
        <h1 class="mb-4">顧客情報更新・削除</h1>

        <form action="actions.php?action=update" method="POST" class="mb-4">
            <input type="hidden" name="id" value="<?= htmlspecialchars($customer['id'], ENT_QUOTES, 'UTF-8') ?>">
            
            <div class="mb-3">
                <label for="name" class="form-label">顧客名 <span class="text-danger">*</span></label>
                <input type="text" class="form-control" id="name" name="name" value="<?= htmlspecialchars($customer['name'], ENT_QUOTES, 'UTF-8') ?>" required>
            </div>
            <div class="mb-3">
                <label for="name_kana" class="form-label">顧客名フリガナ</label>
                <input type="text" class="form-control" id="name_kana" name="name_kana" value="<?= htmlspecialchars($customer['name_kana'], ENT_QUOTES, 'UTF-8') ?>">
            </div>
            <div class="mb-3">
                <label for="address" class="form-label">住所</label>
                <textarea class="form-control" id="address" name="address" rows="5"><?= htmlspecialchars($customer['address'], ENT_QUOTES, 'UTF-8') ?></textarea>
            </div>
            <div class="mb-3">
                <label for="phone" class="form-label">電話番号</label>
                <input type="tel" class="form-control" id="phone" name="phone" value="<?= htmlspecialchars($customer['phone'], ENT_QUOTES, 'UTF-8') ?>">
            </div>
            <div class="mb-3">
                <label for="email" class="form-label">メールアドレス</label>
                <input type="email" class="form-control" id="email" name="email" value="<?= htmlspecialchars($customer['email'], ENT_QUOTES, 'UTF-8') ?>">
            </div>
            
            <button type="submit" class="btn btn-primary">更新</button>
            <a href="index.php" class="btn btn-secondary">一覧に戻る</a>
        </form>

        <form action="actions.php?action=delete" method="POST" onsubmit="return confirm('本当にこの顧客情報を削除しますか？');">
            <input type="hidden" name="id" value="<?= htmlspecialchars($customer['id'], ENT_QUOTES, 'UTF-8') ?>">
            <button type="submit" class="btn btn-danger">削除</button>
        </form>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js" integrity="sha384-geWF76RCwLtnZ8qwWowPQNguL3RmwHVBC9FhGdlKrxdiJJigb/j/68SIy3Te4Bkz" crossorigin="anonymous"></script>
</body>
</html>
