<?php
require_once 'database.php';

$pdo = get_db_connection();
$search_keyword = $_GET['search'] ?? '';

try {
    if ($search_keyword) {
        $stmt = $pdo->prepare(
            "SELECT * FROM customers 
             WHERE name LIKE :keyword 
                OR name_kana LIKE :keyword 
                OR address LIKE :keyword 
                OR phone LIKE :keyword 
                OR email LIKE :keyword 
             ORDER BY id ASC"
        );
        $stmt->bindValue(':keyword', '%' . $search_keyword . '%', PDO::PARAM_STR);
    } else {
        $stmt = $pdo->prepare("SELECT * FROM customers ORDER BY id ASC");
    }
    $stmt->execute();
    $customers = $stmt->fetchAll();
} catch (PDOException $e) {
    die("Error: " . $e->getMessage());
}
?>
<!DOCTYPE html>
<html lang="ja">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>顧客管理システム</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-9ndCyUaIbzAi2FUVXJi0CjmCapSmO7SnpJef0486qhLnuZ2cdeRhO02iuK6FUUVM" crossorigin="anonymous">
</head>
<body>
    <div class="container mt-4">
        <h1 class="mb-4">顧客一覧</h1>

        <div class="row mb-3">
            <div class="col-md-8">
                <form action="index.php" method="GET" class="d-flex">
                    <input type="text" name="search" class="form-control me-2" placeholder="検索キーワード" value="<?= htmlspecialchars($search_keyword, ENT_QUOTES, 'UTF-8') ?>">
                    <button type="submit" class="btn btn-primary">検索</button>
                    <a href="index.php" class="btn btn-secondary ms-2">リセット</a>
                </form>
            </div>
            <div class="col-md-4 text-end">
                <a href="create.php" class="btn btn-success">新規登録</a>
            </div>
        </div>

        <table class="table table-striped table-bordered">
            <thead class="table-dark">
                <tr>
                    <th>ID</th>
                    <th>顧客名</th>
                    <th>フリガナ</th>
                    <th>住所</th>
                    <th>電話番号</th>
                    <th>メールアドレス</th>
                    <th>操作</th>
                </tr>
            </thead>
            <tbody>
                <?php if (empty($customers)): ?>
                    <tr>
                        <td colspan="7" class="text-center">顧客情報がありません。</td>
                    </tr>
                <?php else: ?>
                    <?php foreach ($customers as $customer): ?>
                        <tr>
                            <td><?= htmlspecialchars($customer['id'], ENT_QUOTES, 'UTF-8') ?></td>
                            <td><?= htmlspecialchars($customer['name'], ENT_QUOTES, 'UTF-8') ?></td>
                            <td><?= htmlspecialchars($customer['name_kana'], ENT_QUOTES, 'UTF-8') ?></td>
                            <td><?= nl2br(htmlspecialchars($customer['address'], ENT_QUOTES, 'UTF-8')) ?></td>
                            <td><?= htmlspecialchars($customer['phone'], ENT_QUOTES, 'UTF-8') ?></td>
                            <td><?= htmlspecialchars($customer['email'], ENT_QUOTES, 'UTF-8') ?></td>
                            <td>
                                <a href="edit.php?id=<?= htmlspecialchars($customer['id'], ENT_QUOTES, 'UTF-8') ?>" class="btn btn-sm btn-primary">更新・削除</a>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js" integrity="sha384-geWF76RCwLtnZ8qwWowPQNguL3RmwHVBC9FhGdlKrxdiJJigb/j/68SIy3Te4Bkz" crossorigin="anonymous"></script>
</body>
</html>
